;; This example shows how to write a sector to
;; a DATA format disc
;;
;; This code is public domain and can be used in your
;; own programs.
;; 
;; Written by Kevin Thacker, 2002.
;;
;;------------------------------------------------

;; firmware function to find a RSX
.kl_find_command equ &bcd4

org &8000
nolist

;;------------------------------------------------
;; find BIOS: WRITE SECTOR command
;;
;; This method is compatible with other DOSs that
;; override or provide this command. If the command
;; is not found, then there is no furthur action. Therefore
;; on tape based systems, this code will have no effect.

ld hl,cmd_bios_write_sector
call kl_find_command
ret nc

;; command found

;; store address of command
ld (bios_write_sector),hl

;; store "rom select" of command
ld a,c
ld (bios_write_sector+2),a

;;------------------------------------------------------------------
;; fill buffer with data

ld hl,buffer
ld bc,512
ld e,0
.fb ld (hl),e
inc hl
inc e
dec bc
ld a,b
or c
jr nz,fb

;;------------------------------------------------------------------
;; write 512 bytes of data to track 0, sector &C1 from disc drive 0

;; HL = address of buffer
;; (change this value to define a different buffer address)
ld hl,buffer

;; E = drive number (0 or 1)
;; (change this value to define the disc drive to write to)
ld e,0

;; D = track number
;; (change this value to define the track to write to)
ld d,0

;; C = sector id
;; 
;; sector ids for DATA format disc: &C1, &C2, &C3, &C4, &C5, &C6, &C7, &C8, &C9
;; sector ids for SYSTEM/VENDOR format disc: &41, &42, &43, &44, &45, &46, &47, &48, &49
;;
;; (change this value to define the id of the sector to write to)
ld c,&c1

;; execute command
rst 3
defw bios_write_sector

ret

;;------------------------------------------------------------------

;; this is initialised when the "BIOS: WRITE SECTOR" RSX has been found.
.bios_write_sector
defw 0                    ;; address of function
defb 0                    ;; "rom select" for function


.cmd_bios_write_sector
defb 5+&80				;; this is the "BIOS: WRITE SECTOR" RSX


;;------------------------------------------------------------------

.buffer 
defs 512
